#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

int main(int argc,  char **argv) {
	char *term;
	int set_title = 1;

	/*
	 * Ignore argv[0]
	 */
	argv++; argc--;

	/*
	 * If there is no DISPLAY environment variable set, don't adjust the
	 * title since it causes annoying beeps.  But DO set it if the TERM
	 * environment variable is set to "xterm", "rxvt", or "screen"
	 */
	term = getenv("TERM");
	if (term == NULL) {
		set_title = 0;
	} else {
		if (strcmp(term, "screen") != 0 && \
		    strcmp(term, "xterm") != 0 && \
		    strcmp(term, "rxvt") != 0) {
			if (getenv("DISPLAY") == NULL) {
				set_title = 0;
			}
		}
	}

	if (set_title == 0) {
		return(EXIT_FAILURE);
	}

	/*
	 * Send the magic escape sequences.
	 */
	printf("\033]0;");

	while (argc--) {
		printf("%s", *argv++);
		if (argc != 0) {
			printf(" ");
		}
	}
	printf("\007");

	/*
	 * Flush standard output, this isn't neeed since it will happen when
	 * exit, but it's good to do anyway.
	 */
	fflush(stdout);

	/*
	 * Exit in victory.
	 */
	return(EXIT_SUCCESS);
}
