AC_DEFUN(DC_DO_NETWORK, [
  AC_SEARCH_LIBS(inet_aton, xnet ws2_32 wsock32, [
    AC_DEFINE(HAVE_INET_ATON, [], [Have inet_aton()])
  ], [
    AC_SEARCH_LIBS(inet_addr, nsl ws2_32 wsock32, [
      AC_DEFINE(HAVE_INET_ADDR, [], [Have inet_addr()])
    ], [
      AC_MSG_ERROR(Couldn't find inet_addr or inet_aton)
    ])
  ])
  AC_SEARCH_LIBS(inet_ntoa, socket nsl,, [ AC_MSG_ERROR(Couldn't find inet_ntoa) ])
  AC_SEARCH_LIBS(connect, socket nsl,, [ AC_MSG_ERROR(Couldn't find connect) ])
])

AC_DEFUN(DC_DO_WIN32, [
  AC_CHECK_HEADERS(windows.h windowsx.h winsock2.h)
  AC_CHECK_LIB(wsock32, main, [
    AC_DEFINE(HAVE_LIBWSOCK32, [], [Have libwsock32])
      LIBS="${LIBS} -lwsock32"
  ])
])

AC_DEFUN(DC_DO_TYPE, [
	if test -z "$ac_cv_sizeof_long"; then
		AC_C_INLINE
		AC_CHECK_SIZEOF(long long, 8)
		AC_CHECK_SIZEOF(long, 4)
		AC_CHECK_SIZEOF(int, 4)
		AC_CHECK_SIZEOF(short, 2)
	fi
	FOUND=0
	for dc_cv_loop in \$ac_cv_sizeof_long_long \$ac_cv_sizeof_int \$ac_cv_sizeof_long \$ac_cv_sizeof_short; do
		dc_cv_size=`eval echo $dc_cv_loop`
		dc_cv_name=`echo $dc_cv_loop | sed s/\\\$ac_cv_sizeof_//`
		if test "$dc_cv_size" = "$3"; then
			if test "$dc_cv_name" = "int"; then 
				AC_CHECK_TYPE($1, $2 int)
			fi
			if test "$dc_cv_name" = "long"; then
				AC_CHECK_TYPE($1, $2 long)
			fi
			if test "$dc_cv_name" = "long_long"; then
				AC_CHECK_TYPE($1, $2 long long)
			fi
			if test "$dc_cv_name" = "short"; then
				AC_CHECK_TYPE($1, $2 short)
			fi
			FOUND=1
			break
		fi
	done
])
