#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "win32.h"

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "gettimeofday.h"

int gettimeofday(struct timeval *tv, void *tz) {
	int retval = -1;
#ifndef _USE_WIN32_
	tv->tv_sec = time(NULL);
	tv->tv_usec = 0;
	retval = 0;
#else
	struct tm lt;
	SYSTEMTIME st;

	GetSystemTime(&st);

	lt.tm_year = st.wYear - 1900;
	lt.tm_mon = st.wMonth - 1;
	lt.tm_mday = st.wDay;
	lt.tm_hour = st.wHour;
	lt.tm_min = st.wMinute;
	lt.tm_sec = st.wSecond;
	lt.tm_isdst = 0;

	tv->tv_sec = mktime(&lt);
	tv->tv_usec = st.wMilliseconds * 1000;

	retval = 0;
#endif
	return(retval);
}
