/*
 * Copyright (C) 2004, 2005  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author Information
 *      Roy Keene
 *      htp@rkeene.org
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "win32.h"

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "gettimeofday.h"

int gettimeofday(struct timeval *tv, void *tz) {
	int retval = -1;
#ifndef _USE_WIN32_
	tv->tv_sec = time(NULL);
	tv->tv_usec = 0;

	retval = 0;
#else
	SYSTEMTIME st;

	GetSystemTime(&st);

	tv->tv_sec = time(NULL);
	tv->tv_usec = st.wMilliseconds * 1000;

	retval = 0;
#endif
	return(retval);
}
