/*
 * Copyright (C) 2005  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author Information
 *      Roy Keene
 *      Planning Systems Inc
 *      Slidell, LA
 *      backuppcd-bugs@psislidell.com
 */

#include "compat.h"

#ifndef HAVE_HTONLL

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#ifdef HAVE_ENDIAN_H
#include <endian.h>
#endif

#ifndef __BIG_ENDIAN
#define __BIG_ENDIAN 4321
#endif
#ifndef __LITTLE_ENDIAN
#define __LITTLE_ENDIAN 1234
#endif

#ifndef __BYTE_ORDER
#ifdef WORDS_BIGENDIAN
#define __BYTE_ORDER __BIG_ENDIAN
#else
#define __BYTE_ORDER __LITTLE_ENDIAN
#endif
#endif

#include "htonll.h"

uint64_t htonll(uint64_t n) {
	uint64_t retval;

#if __BYTE_ORDER == __BIG_ENDIAN
	retval = n;
#else
	retval = ((uint64_t) htonl(n & 0xFFFFFFFFLLU)) << 32;
	retval |= htonl((n & 0xFFFFFFFF00000000LLU) >> 32);
#endif
	return(retval);
}

#endif
