#include "compat.h"

/*
 * We may be compiled even if a gethostname() function exists, therefore
 * if we detect that it does exist we should not do anything.
 */
#ifndef HAVE_GETHOSTNAME

#include "gethostname.h"

int gethostname(char *name, size_t len) {
	int retval = -1;
#ifdef _USE_WIN32_
	BOOL gcn_ret;
	char *tmpname;

	tmpname = malloc(len);

	gcn_ret = GetComputerName(tmpname, &len);
	if (gcn_ret) {
		memcpy(name, tmpname, len);
		name[len] = '\0';

		retval = 0;
	}

	free(tmpname);
#endif
	return(retval);
}

#endif
