/*
 * Copyright (C) 2005  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author Information
 *      Roy Keene
 *      Planning Systems Inc
 *      Slidell, LA
 *      backuppcd-bugs@psislidell.com
 */


#ifndef RSK_COMPAT_H
#define RSK_COMPAT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef __WIN32__
#include "win32.h"
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#else
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif
#endif
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#ifndef HAVE_SOCKLEN_T
#ifdef NEED_SOCKLEN_T
typedef int socklen_t;
#endif
#endif

#ifndef HAVE_HTONLL
#include "htonll.h"
#endif

#ifndef HAVE_NTOHLL
#include "ntohll.h"
#endif

#ifndef HAVE_STRSEP
#include "strsep.h"
#endif

#ifndef HAVE_GETHOSTNAME
#include "gethostname.h"
#endif

#ifdef HAVE_STATFS
/*
 * These constants are used to determine the filesystem type from statfs().
 * Only used under Linux as other statfs() implementations return ftype == 0.
 */
#ifndef NFS_SUPER_MAGIC
#define NFS_SUPER_MAGIC   0x6969
#endif
#ifndef PROC_SUPER_MAGIC
#define PROC_SUPER_MAGIC  0x9fa0
#endif
#ifndef DEVFS_SUPER_MAGIC
#define DEVFS_SUPER_MAGIC 0x1373
#endif
#ifndef ISOFS_SUPER_MAGIC
#define ISOFS_SUPER_MAGIC 0x9660
#endif
#ifndef NCP_SUPER_MAGIC
#define NCP_SUPER_MAGIC   0x564c
#endif
#ifndef SMB_SUPER_MAGIC
#define SMB_SUPER_MAGIC   0x517B
#endif
#ifndef TMPFS_MAGIC
#define TMPFS_MAGIC       0x01021994
#endif
#endif



#ifdef DEBUG
#define PRINT_LINE fprintf(stderr, "%lu:%s:%i:%s(): ", (unsigned long) time(NULL), __FILE__, __LINE__, __func__); 
#define PRINTERR_D(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); }
#define PERROR(x) { PRINT_LINE; perror(x); }
#define DPERROR(x) PERROR(x)
#define DPRINTF(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); }
#else
#define PRINT_LINE /**/
#define PRINTERR_D(x...) /**/
#define PERROR(x) perror(x);
#define DPERROR(x) /**/
#endif
#define CHECKPOINT PRINTERR_D("*** CHECKPOINT REACHED ***")
#define SPOTVAR_LLX(x) PRINTERR_D(#x " = %llx", (unsigned long long) x)
#define SPOTVAR_LLU(x) PRINTERR_D(#x " = %llu", (unsigned long long) x)
#define SPOTVAR_LU(x) PRINTERR_D(#x " = %lu", (unsigned long) x)
#define SPOTVAR_D(x) PRINTERR_D(#x " = %lf", x)
#define SPOTVAR_X(x) PRINTERR_D(#x " = 0x%x", (unsigned int) x)
#define SPOTVAR_I(x) PRINTERR_D(#x " = %i", (int) x)
#define SPOTVAR_P(x) PRINTERR_D(#x " = %p", x)
#define SPOTVAR_S(x) PRINTERR_D(#x " = \"%s\"", x)
#define PRINTERR(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); fflush(stderr); }
#define LOG(x...) { PRINT_LINE; fprintf(stderr, "LOG: " x); fprintf(stderr, "\n"); }

#endif
