#include "compat.h"
#include "sha1.h"

int main(int argc, char **argv) {
	char *plaintext;
	char *fgets_ret;
	int fail_cnt = 0;

	if (argc == 1) {
		plaintext = malloc(1024);
		if (!plaintext) {
			perror("malloc");
			return(EXIT_FAILURE);
		}

		plaintext[0] = '\0';

		while (plaintext[0] == '\0' && fail_cnt < 3) {
			printf("Password: ");
			fflush(stdout);

			fgets_ret = fgets(plaintext, 1024, stdin);
			if (!fgets_ret) {
				perror("fgets");
				return(EXIT_FAILURE);
			}

			if (plaintext[strlen(plaintext) - 1] == '\n') {
				plaintext[strlen(plaintext) - 1] = '\0';
			}

			fail_cnt++;
		}
	} else if (argc > 1) {
		plaintext = argv[1];
	} else {
		return(EXIT_FAILURE);
	}

	if (plaintext[0] == '\0') {
		printf("Invalid password specified, aborting.\n");
		exit(EXIT_FAILURE);
	}

	printf("%s\n", SHA1sum(plaintext));

	return(EXIT_SUCCESS);
}
