AC_DEFUN(DC_DO_NETWORK, [

  AC_CHECK_HEADERS(arpa/inet.h errno.h fcntl.h netdb.h netinet/in.h stdarg.h stdio.h stdlib.h string.h sys/socket.h sys/stat.h sys/types.h unistd.h)

  AC_CHECK_TYPE(socklen_t, [
    AC_DEFINE(HAVE_SOCKLEN_T, [1], [Define to 1 if you have the "socklen_t" type.])
  ], [
    AC_DEFINE(NEED_SOCKLEN_T, [1], [Define to 1 if you need the "socklen_t" type.])
  ], [
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
  ])

  AC_SEARCH_LIBS(inet_aton, xnet ws2_32 wsock32, [
    AC_DEFINE(HAVE_INET_ATON, [1], [Have inet_aton()])
  ], [
    AC_SEARCH_LIBS(inet_addr, nsl ws2_32 wsock32, [
      AC_DEFINE(HAVE_INET_ADDR, [1], [Have inet_addr()])
    ], [
      AC_MSG_WARN([Couldn't find inet_addr or inet_aton])
    ])
  ])
  AC_SEARCH_LIBS(connect, socket nsl ws2_32 wsock32,, [ AC_MSG_WARN([Couldn't find connect]) ])
  AC_SEARCH_LIBS(inet_ntoa, socket nsl ws2_32 wsock32,, [ AC_MSG_WARN([Couldn't find inet_ntoa]) ])
])

AC_DEFUN(DC_DO_WIN32, [
  AC_CHECK_HEADERS(windows.h windowsx.h winsock2.h)

  AC_CHECK_LIB(wsock32, main, [
    AC_DEFINE(HAVE_LIBWSOCK32, [1], [Have libwsock32])
      LIBS="${LIBS} -lwsock32"
  ])
])

AC_DEFUN(DC_DO_TYPE, [
	if test -z "$ac_cv_sizeof_long"; then
		AC_C_INLINE
		AC_CHECK_SIZEOF(long long, 8)
		AC_CHECK_SIZEOF(long, 4)
		AC_CHECK_SIZEOF(int, 4)
		AC_CHECK_SIZEOF(short, 2)
	fi
	FOUND=0
	for dc_cv_loop in \$ac_cv_sizeof_long_long \$ac_cv_sizeof_int \$ac_cv_sizeof_long \$ac_cv_sizeof_short; do
		dc_cv_size=`eval echo $dc_cv_loop`
		dc_cv_name=`echo $dc_cv_loop | sed s/\\\$ac_cv_sizeof_//`
		if test "$dc_cv_size" = "$3"; then
			if test "$dc_cv_name" = "int"; then 
				AC_CHECK_TYPE($1, $2 int)
			fi
			if test "$dc_cv_name" = "long"; then
				AC_CHECK_TYPE($1, $2 long)
			fi
			if test "$dc_cv_name" = "long_long"; then
				AC_CHECK_TYPE($1, $2 long long)
			fi
			if test "$dc_cv_name" = "short"; then
				AC_CHECK_TYPE($1, $2 short)
			fi
			FOUND=1
			break
		fi
	done
])

AC_DEFUN(DC_SETLDRUNPATH, [
  OLD_LDFLAGS="$LDFLAGS"

  LDRUNPATH=""
  for testldflags in "-Wl,-rpath -Wl,$1" "-Wl,-R -Wl,$1"; do
    LDFLAGS="$OLD_LDFLAGS $testldflags"
    AC_TRY_LINK([#include <stdio.h>],
                [ return(0); ], [ LDRUNPATH="$LDRUNPATH $testldflags"; break ]);
  done

  LDFLAGS="$OLD_LDFLAGS"
  if test -n "$LDRUNPATH"; then
    LDFLAGS="$LDRUNPATH $LDFLAGS"
  fi
])


AC_DEFUN(DC_ASK_OPTLIB, [
  LIBSPECLIBDIR=""
  AC_ARG_WITH($5, AC_HELP_STRING(--with-$5, $4), [
# Specified
    LIBSPEC=$withval
  ], [
# Not specified
    LIBSPECFLAGS="`pkg-config --libs $5 2>/dev/null`"
    LIBSPECCFLAGS="`pkg-config --cflags $5 2>/dev/null`"
    AC_CHECK_LIB($1, $2, [
      OLDCPPFLAGS="$CPPFLAGS"
      OLDCFLAGS="$CFLAGS"
      CPPFLAGS="$CPPFLAGS $LIBSPECCFLAGS"
      CFLAGS="$CFLAGS $LIBSPECCFLAGS"
      if test -n "$3" ; then
        AC_CHECK_HEADER($3, [
          LIBSPEC=yes
        ], [
          LIBSPEC=no
        ])
      fi
      CPPFLAGS="$OLDCPPFLAGS"
      CFLAGS="$OLDCFLAGS"
    ], [
      if test -n "$8"; then

	dnl The next line hopefully just invalidates the cache.
        unset `set | grep _cv_ | cut -f 1 -d =`

        LIBSPECFLAGS="$8 $LIBSPECFLAGS"
        AC_CHECK_LIB($1, $2, [
          OLDCPPFLAGS="$CPPFLAGS"
          OLDCFLAGS="$CFLAGS"
          CPPFLAGS="$CPPFLAGS $LIBSPECCFLAGS"
          CFLAGS="$CFLAGS $LIBSPECCFLAGS"
          if test -n "$3" ; then
            AC_CHECK_HEADER($3, [
              LIBSPEC=yes
            ], [
              LIBSPEC=no
            ])
          fi
          CPPFLAGS="$OLDCPPFLAGS"
          CFLAGS="$OLDCFLAGS"
        ], [
	  dnl The next line hopefully just invalidates the cache.
          unset `set | grep _cv_ | cut -f 1 -d =`

          LIBSPECFLAGS="$8"
          AC_CHECK_LIB($1, $2, [
            OLDCPPFLAGS="$CPPFLAGS"
            OLDCFLAGS="$CFLAGS"
            CPPFLAGS="$CPPFLAGS $LIBSPECCFLAGS"
            CFLAGS="$CFLAGS $LIBSPECCFLAGS"
            if test -n "$3" ; then
              AC_CHECK_HEADER($3, [
                LIBSPEC=yes
              ], [
                LIBSPEC=no
              ])
            fi
            CPPFLAGS="$OLDCPPFLAGS"
            CFLAGS="$OLDCFLAGS"
          ], [
            LIBSPEC=no
            $9
            AC_MSG_WARN(Did not find $5)
          ], $LIBSPECFLAGS)
        ], $LIBSPECFLAGS)
      else
        LIBSPEC=no
        $9
        AC_MSG_WARN(Did not find $5)
      fi
    ], $LIBSPECFLAGS)
  ])
  case $LIBSPEC in
  	no)
                $9
  		AC_MSG_WARN(Support for $5 disabled)
  		;;
  	*)
  		if test "${LIBSPEC}" = "yes"; then
			true
		else
			LIBSPECLIBDIR="${LIBSPEC}/lib"
			LIBSPECFLAGS="-L${LIBSPEC}/lib ${LIBSPECFLAGS}"
			LIBSPECCFLAGS="-I${LIBSPEC}/include ${LIBSPECCFLAGS}"
  		fi
		AC_CHECK_LIB($1, $2, [
		  OLDCFLAGS="$CFLAGS"
		  OLDCPPFLAGS="$CPPFLAGS"
		  CPPFLAGS="$CPPFLAGS ${LIBSPECCFLAGS}"
		  CFLAGS="$CFLAGS ${LIBSPECCFLAGS}"
		  if test -n "$3"; then
  		    AC_CHECK_HEADER($3, [
		      headerok="yes"
		    ], [
		      headerok="no"
		    ])
		  else
		    headerok="yes"
		  fi

		  if test $headerok = "yes"; then
		    if test -n "$7" -a -n "$3"; then
		      AC_DEFINE($7, [1], [Define to 1 if you have the <$3> header file.])
		    fi
		    if test -n "$6" -a -n "$2"; then
		      AC_DEFINE($6, [1], [Define to 1 if you have $2 from $5])
		    fi
		    LDFLAGS="$LIBSPECFLAGS $LDFLAGS"
                    if test -n "$LIBSPECLIBDIR"; then
                      DC_SETLDRUNPATH($LIBSPECLIBDIR)
                    fi
		    LIBS="-l$1 $LIBS"
		  else
		    CFLAGS="$OLDCFLAGS"
		    CPPFLAGS="$OLDCPPFLAGS"
                    $9
		    AC_MSG_ERROR(Could not find $3)
		  fi
		], [
		  AC_MSG_ERROR(Could not find $5)
		], $LIBSPECFLAGS)
  		;;
  esac
])

AC_DEFUN(DC_CHK_OS_INFO, [
	AC_CANONICAL_HOST
	AC_SUBST(CFLAGS)
	AC_SUBST(CPPFLAGS)
	AC_SUBST(AREXT)

	AC_MSG_CHECKING(host operating system)
	AC_MSG_RESULT($host_os)

	AREXT=".a"

	case $host_os in
		mingw32msvc*)
			CFLAGS="$CFLAGS -mno-cygwin -mms-bitfields"
			CPPFLAGS="$CPPFLAGS -mno-cygwin -mms-bitfields"
			;;
		cygwin*)
			CFLAGS="$CFLAGS -mms-bitfields"
			CPPFLAGS="$CPPFLAGS -mms-bitfields"
			;;

	esac
])

AC_DEFUN(DC_MAKE_STATIC, [
	AC_SUBST(LIBS)
	AC_SUBST(LDFLAGS)
	NEWLIBS=""
	NEWLDFLAGS=""

	rm -f conftest conftest.c
	cat <<\_ACEOF > conftest.c
#include <stdio.h>
int main(void) { return(0); }
_ACEOF
	"$CC" -o conftest $CFLAGS $CPPFLAGS $LDFLAGS conftest.c $LIBS >/dev/null 2>/dev/null
	if test -e conftest; then
		if test -z "$LDD"; then
			LDD=`echo "$CC" | sed 's@gcc$[@]ldd@'`
			if test "$LDD" = "$CC"; then
				LDD=`echo "$CC" | sed 's@cc$[@]ldd@'`
			fi
			if test "$LDD" = "$CC"; then
				LDD=false
			fi
		fi
		"$LDD" conftest 2>/dev/null >conftest.ldd
	fi
	rm -f conftest conftest.c

	if test -e conftest.ldd; then
		for lib in $LIBS; do
			if echo "$lib" | grep '\-l' >/dev/null; then
				libname=`echo "$lib" | sed 's@^-l@@'`
				testlib=`cat conftest.ldd | awk '{ print $[3] }' | sed 's@\..*$[@]@' | grep "/lib$libname$"`.a
				if test -e "$testlib" -a -n "$testlib"; then
					lib="$testlib"
				fi
			fi
			NEWLIBS="$NEWLIBS $lib"
		done
		for lib in $LDFLAGS; do
			if echo "$lib" | grep '\-l' >/dev/null; then
				libname=`echo "$lib" | sed 's@^-l@@'`
				testlib=`cat conftest.ldd | awk '{ print $[3] }' | sed 's@\..*$[@]@' | grep "/lib$libname$"`.a
				if test -e "$testlib" -a -n "$testlib"; then
					lib="$testlib"
				fi
			fi
			NEWLDFLAGS="$NEWLDFLAGS $lib"
		done

		LIBS="$NEWLIBS"
		LDFLAGS="$NEWLDFLAGS"
	fi

	rm -f conftest.ldd
])
